unit ComInterface;

interface

uses
  SysUtils, Classes, Variants, EmapaLocalizeCOM_TLB;

const
  OBJECT_FIELD_COUNT = 11;
  POSITION_FIELD_COUNT = 9;

type
  TValueArrayObject = array of array[0..OBJECT_FIELD_COUNT-1] of String;
  TValueArrayPosition = array of array of String;
  TReportArray = array of array[0..7] of String;
  TAdditionalFieldType = (aftString, aftNumeric, aftUnknown);
  TAdditionalFieldTypeArray = array of TAdditionalFieldType;

//
// Procedura powodujca wizualizacj obiektw i ich cieek na mapie
//
// AFieldArray: tablica zawierajca definicje pl tekstowych, ktre mog suy do
//              opisania wybranych pozycji na mapie dla lokalizowanych obiektw
// AValueArrayObject: dwuwymiarowa tablica wasnoci obiektw
// AValueArrayPosition: dwuwymiarowa tablica wasnoci pozycji lokalizowanego obiektu
//   na mapie. Pierwsze pole w kadym wierszu okrela unikalny identyfikator obiektu
//   (EntID), do ktrego odnosi si dana pozycja
// AAdditionalFieldTypeArray: tablica okrelajca typy pl dodatkowych. Zalenie od typu
// dane pole bdzie dodawane jako tekstowe bd numeryczne
//
procedure LocalizeCollectionProc(AFieldArray: array of String; AValueArrayObject: TValueArrayObject; AValueArrayPosition: TValueArrayPosition; AAdditionalFieldTypeArray: TAdditionalFieldTypeArray; AFitViewToCollection: Boolean);

//
// Funkcja umoliwiajca uzyskanie jednego z trzech raportw z aktualnego stanu obiektw na mapie
//
// AReportAccuracy: okrela jeden z trzech moliwych rodzajw raportu
// AEntID: uywane tylko gdy AReportAccuracy=ReportSelected. Wwczas raport zawiera
//   wszystkie wpisy dotyczce obiektu o identyfikatorze AEntID
// APosition: uywane tylko gdy AReportAccuracy=ReportSelected. Zawa raport do wpisu
//   dotyczcego obiektu o identyfikatorze AEntID i pozycji o numerze APosition
//
// Funkcja zwraca dwuwymiarow tablic zawierajc pola raportu
//
function RetrieveReportProc(AReportAccuracy: ReportSelectionEnum; AEntID: Integer; APosition: OleVariant): TReportArray;

//
// Procedura umoliwiajca wyczyszczenie aktualnie pokazywanej kolekcji
//
procedure CleanLocalizeInfoProc;

implementation

var
  FLocalizeApp: ILocalizeApp;

function StrToBoolEx(AValue: String): Boolean;
begin
  if AnsiUpperCase(AValue) = 'TAK' then
    AValue := 'TRUE';
  if AnsiUpperCase(AValue) = 'NIE' then
    AValue := 'FALSE';

  Result := StrToBool(AValue);
end;

//
// Funkcja zwraca z kolekcji ALocalizeCollection lokalizowany obiekt majcy
// unikalny identyfikator (EntID) rwny AEntID
//
function GetLocalizeObject(AEntID: String; ALocalizeCollection: ILocalizeCollection): ILocalizeObject;
var
  i: Integer;
  LocalizeObject: ILocalizeObject;
begin
  Result := nil;
  for i := 1 to ALocalizeCollection.Count do
  begin
    LocalizeObject := ALocalizeCollection.Item[i] as ILocalizeObject;
    if IntToStr(LocalizeObject.EntID) = AEntID then
    begin
      Result := LocalizeObject;
      Break;
    end;
  end;
end;

procedure AddAdditionalFields(AFieldArray: array of String; AAdditionalFieldTypeArray: TAdditionalFieldTypeArray);
var
  i: Integer;
  LocalizeConfiguration: ILocalizeConfiguration;
begin
  LocalizeConfiguration := FLocalizeApp.LocalizeConfiguration as ILocalizeConfiguration;

  for i := Low(AFieldArray) to High(AFieldArray) do
  begin
    if i < Length(AAdditionalFieldTypeArray) then
    begin
      if AAdditionalFieldTypeArray[i] = aftNumeric then
      begin
        with LocalizeConfiguration.AdditionalNumericEntriesCollection do
          Add(AFieldArray[i], EmptyParam, EmptyParam, EmptyParam);
      end
      else begin
        with LocalizeConfiguration.AdditionalStringEntriesCollection do
          Add(AFieldArray[i], EmptyParam, EmptyParam, EmptyParam);
      end;
    end;
  end;
end;

procedure AddLocalizeObjects(ALocalizeCollection: ILocalizeCollection; AValueArray: TValueArrayObject);
var
  i: Integer;
begin
  for i := Low(AValueArray) to High(AValueArray) do
  begin
    with ALocalizeCollection.Add(EmptyParam, EmptyParam) as ILocalizeObject do
    begin
      EntID := StrToInt(AValueArray[i, 0]);
      Name := AValueArray[i, 1];
      IconIndex := StrToInt(AValueArray[i, 2]);
      ShowIcon := StrToBoolEx(AValueArray[i, 3]);
      IconColor := StrToInt(AValueArray[i, 4]);
      PathColor := StrToInt(AValueArray[i, 5]);
      PathWidth := StrToInt(AValueArray[i, 6]);
      Size := StrToInt(AValueArray[i, 7]);
      RemovePrevious := StrToBoolEx(AValueArray[i, 8]);
      PointsConnected := StrToBoolEx(AValueArray[i, 9]);
      ShowName := StrToBoolEx(AValueArray[i, 10]);
    end;
  end;
end;

procedure AddPositions(ALocalizeCollection: ILocalizeCollection; AValueArray: TValueArrayPosition; AAdditionalFieldTypeArray: TAdditionalFieldTypeArray);
var
  i, j, NumericFieldIndex, StringFieldIndex: Integer;
  LocalizeObject: ILocalizeObject;
begin
  for i := Low(AValueArray) to High(AValueArray) do
  begin
    LocalizeObject := GetLocalizeObject(AValueArray[i, 0], ALocalizeCollection);
    if Not Assigned(LocalizeObject) then
      Break;

    with LocalizeObject.Positions.Add(EmptyParam, EmptyParam, EmptyParam, EmptyParam) as IPosition do
    begin
      Longitude := StrToFloat(AValueArray[i, 1]);
      Latitude := StrToFloat(AValueArray[i, 2]);
      Time := StrToTime(AValueArray[i, 3]);
      Description := AValueArray[i, 4];
      IconIndex := StrToInt(AValueArray[i, 5]);
      ShowIcon := StrToBoolEx(AValueArray[i, 6]);
      IconColor := StrToInt(AValueArray[i, 7]);
      ShowName := StrToBoolEx(AValueArray[i, 8]);
      ShowDescription := StrToBoolEx(AValueArray[i, 9]);

      NumericFieldIndex := 1;
      StringFieldIndex := 1;

      for j := 0 to Length(AAdditionalFieldTypeArray)-1 do
      begin
        if AAdditionalFieldTypeArray[j] = aftNumeric then
        begin
          if AValueArray[i, Length(AValueArray[i])-Length(AAdditionalFieldTypeArray)+j] <> '' then
            AdditionalNumericField[NumericFieldIndex] := AValueArray[i, Length(AValueArray[i])-Length(AAdditionalFieldTypeArray)+j];
          Inc(NumericFieldIndex);
        end
        else begin
          if AValueArray[i, Length(AValueArray[i])-Length(AAdditionalFieldTypeArray)+j] <> '' then
            AdditionalStringField[StringFieldIndex] := AValueArray[i, Length(AValueArray[i])-Length(AAdditionalFieldTypeArray)+j];
          Inc(StringFieldIndex);
        end;
      end;
    end;
  end;
end;

procedure LocalizeCollectionProc(AFieldArray: array of String; AValueArrayObject: TValueArrayObject; AValueArrayPosition: TValueArrayPosition; AAdditionalFieldTypeArray: TAdditionalFieldTypeArray; AFitViewToCollection: Boolean);
var
  LocalizeCollection: ILocalizeCollection;
begin
  if FLocalizeApp = nil then
    FLocalizeApp := CoLocalizeApp.Create;

  // Tworzenie obiektu LocalizeCollection odbywa si teraz za pomoc metody
  // CreateLocalizeCollection obiektu LocalizeApp.
  // Tak wygldaa stara metoda tworzenia obiektu LocalizeCollection:
  //  LocalizeCollection := CoLocalizeCollection.Create;
  LocalizeCollection := FLocalizeApp.CreateLocalizeCollection;

  AddAdditionalFields(AFieldArray, AAdditionalFieldTypeArray);
  AddLocalizeObjects(LocalizeCollection, AValueArrayObject);
  AddPositions(LocalizeCollection, AValueArrayPosition, AAdditionalFieldTypeArray);

  FLocalizeApp.LocalizeCollection(LocalizeCollection, AFitViewToCollection);

  LocalizeCollection := nil;
end;

function RetrieveReportProc(AReportAccuracy: ReportSelectionEnum; AEntID: Integer; APosition: OleVariant): TReportArray;
var
  i: Integer;
  Report: IReportCollection;
begin
  if FLocalizeApp = nil then
    Exit;

  Report := FLocalizeApp.RetrieveReport(AReportAccuracy, AEntID, APosition);
  for i := 1 to Report.Count do
  begin
    SetLength(Result, Length(Result)+1);
    with Report.Item[i] as IReportEntry do
    begin
      Result[Length(Result)-1, 0] := InttoStr(EntID);
      Result[Length(Result)-1, 1] := InttoStr(PositionInCollection);
      Result[Length(Result)-1, 2] := TimeToStr(Time);
      Result[Length(Result)-1, 3] := Neighbourhood;
      Result[Length(Result)-1, 4] := Name;
      Result[Length(Result)-1, 5] := Country;
      Result[Length(Result)-1, 6] := County;
      Result[Length(Result)-1, 7] := State;
    end;
  end;
  Report := nil;
end;

procedure CleanLocalizeInfoProc;
begin
  if Assigned(FLocalizeApp) then
    FLocalizeApp.CleanLocalizeInfo;
end;

end.
